; I-Imagine Tween Shader
;
; Author: Dan Wagner
;
; v0 = position x1, y1, z1
; v1 = unsued
; v2 = unused 
; v3 = normal nx1, ny1, nz1
; v4 = texture coordinates tu1, tv1
; v5 = unused
; v6 = position x2, y2, z2
; v7 = normal nx2, ny2, nz2
; v8 = texture coordinates tu2, tv2
;
; c[82]..c[83] = texture transpose matrix
; c[84].x = tween factor (value between 0.0f & 1.0f)
; c[85]..c[87] = world rotation matrix
; c[88]..c[91] = concatanated world, view, projection matrix
; c[92] = light direction
; c[93] = ambient color value
; c[94] = diffuse color value
; c[95] = 0.0f, 1.0f, -1.0f, 0.0f

xvs.1.1

def c95, 0.0f, 1.0f, -1.0f, 0.0f

;calculate the difference between the two vertices (vert2 - vert1)
mov r3, v0
mov r4, v3
sub r0, v6, r3	;position difference
sub r1, v7, r4	;normal difference

;tween the value by linearly interpolating using the tween factor (res = vert1 + (vert2 - vert1) * tweenFactor)
mad r2, r0, c84.x, v0 ;tween position
mad r3, r1, c84.x, v3 ;tween normal

;transform and project the tweened vert
m4x4 oPos, r2, c88

;rotate the tweened normal by the world rotation
m4x3 r4, r3, c85

;normalize the tweened normal
dp3 r4.w, r4, r4
rsq r4.w, r4.w
mul r4, r4, r4.w

;do lighting calculation using the tweened normal
;dot the vert normal with the light direction
dp3 r4.x, r4, c92
max r4.x, r4.x, c95.x       ;if dot < 0 then dot = 0

;calculate intensity by multiplying with diffuse
mul r7.x, r4.x, c94

;add the ambient color and store in output register
add oD0, c93, r7.x

;Compute fog factor (fogVal = sqrt(dot(pos, pos)) 
dp3 r5.w, r12, r12
rsq r6.w, r5.w
mul oFog.x, r5.w, r6.w

;NOTE: Currently no tweening is done for uv's
;move the texture coordinate to the texture output register

;multiply by the texture matrix
dp3 oT0.x, v4.xyw, c82.xyz
dp3 oT0.y, v4.xyw, c83.xyz
